package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.uploader.log.DescribableResult;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.file.File2;

/**
 * Uploaded locally mulca file
 * XXX actually, DownloadedMulcaFile
 * @author akirakozov
 */
public class UploadedMulcaFile implements DescribableResult {
    @JsonProperty
    private final File2 localFile;
    @JsonProperty
    private final MulcaId mulcaId;

    @JsonCreator
    public UploadedMulcaFile(
            @JsonProperty("localFile") File2 localFile,
            @JsonProperty("mulcaId") MulcaId mulcaId)
    {
        this.localFile = localFile;
        this.mulcaId = mulcaId;
    }

    public File2 getLocalFile() {
        return localFile;
    }

    public MulcaId getMulcaId() {
        return mulcaId;
    }

    @Override
    public MapF<String, String> describe() {
        return Cf.map("mulca_id", mulcaId.toSerializedString())
                .plus1("content_length", Long.toString(localFile.length()));
    }
}
