package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.chemodan.mpfs.MpfsResourceInfo;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.Validate;

/**
 * @author ssytnik
 */
public class ZipResourceInfo extends DefaultObject {

    @JsonProperty
    String normalizedPath;
    @JsonProperty
    Option<FileToZipInfo> fileInfo;


    public ZipResourceInfo(
            @JsonProperty("normalizedPath") String normalizedPath,
            @JsonProperty("info") Option<FileToZipInfo> fileInfo)
    {
        this.normalizedPath = normalizedPath;
        this.fileInfo = fileInfo;
    }


    public String getNormalizedPath() {
        return normalizedPath;
    }

    public Option<FileToZipInfo> getFileInfoO() {
        return fileInfo;
    }

    public boolean isFile() {
        return fileInfo.isPresent();
    }

    public static Function1B<ZipResourceInfo> isFileF() {
        return info -> info.isFile();
    }


    public static ZipResourceInfo consFromMpfsInfo(MpfsResourceInfo info, String rootFolderName) {
        Validate.equals(info.isFolder(), !info.getMulcaIdO().isPresent());
        Validate.isTrue(info.getNormalizedPath().startsWith("/"));
        String normalizedPath = rootFolderName + info.getNormalizedPath();

        if (!info.isFolder()) {
            FileToZipInfo fInfo = new FileToZipInfo(
                    info.getHidO().get(),
                    info.getMulcaIdO().get(),
                    info.getSizeO().get(),
                    info.getMediaTypeO().get(),
                    info.getMimeTypeO().get()
            );
            return new ZipResourceInfo(normalizedPath, Option.of(fInfo));
        } else {
            return new ZipResourceInfo(normalizedPath, Option.empty());
        }
    }

    public static Function<MpfsResourceInfo, ZipResourceInfo> consFromMpfsInfoF(final String rootFolderName) {
        return info -> consFromMpfsInfo(info, rootFolderName);
    }

}
