package ru.yandex.chemodan.uploader.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.commune.uploader.log.DescribableResult;
import ru.yandex.commune.uploader.util.http.IncomingFile;
import ru.yandex.misc.lang.DefaultToString;

/**
 * @author metal
 */
public abstract class AbstractServiceIncomingFile extends DefaultToString implements DescribableResult {
    @JsonProperty
    private final IncomingFile incomingFile;
    @JsonProperty
    private final Option<ServiceFileId> serviceFileId;
    @JsonProperty
    private final ChemodanService service;

    @JsonCreator
    public AbstractServiceIncomingFile(
            @JsonProperty("incomingFile") IncomingFile incomingFile,
            @JsonProperty("serviceFileId") Option<ServiceFileId> serviceFileId,
            @JsonProperty("service") ChemodanService service)
    {
        this.incomingFile = incomingFile;
        this.serviceFileId = serviceFileId;
        this.service = service;
    }

    public IncomingFile getIncomingFile() {
        return incomingFile;
    }

    public Option<ServiceFileId> getServiceFileId() {
        return serviceFileId;
    }

    public ChemodanService getService() {
        return service;
    }

    @Override
    public MapF<String, String> describe() {
        MapF<String, String> parameters = Cf.map("service", service.name().toLowerCase())
                .plus(incomingFile.describe());

        if (serviceFileId.isPresent()) {
            return parameters
                    .plus1("uid", serviceFileId.get().uid.toString())
                    .plus1("file-id", serviceFileId.get().n);
        } else {
            return parameters;
        }
    }
}
