package ru.yandex.chemodan.uploader.services;

import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.browser.BrowserApiMdsClient;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentUtils;
import ru.yandex.inside.mds.MdsFileKey;

/**
 * @author akirakozov
 */
public class BrowserApi implements ServiceApi {
    private final BrowserApiMdsClient browserApiMdsClient;

    public BrowserApi(BrowserApiMdsClient browserApiMdsClient) {
        this.browserApiMdsClient = browserApiMdsClient;
    }

    @Override
    public ServicePublishResult publish(ChemodanFile file, Content content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Content download(ServiceFileId id) {
        return ContentUtils.ofUnknownType(browserApiMdsClient.download(MdsFileKey.parse(id.n)));
    }

    @Override
    public ChemodanService getService() {
        return ChemodanService.BROWSER;
    }
}
