package ru.yandex.chemodan.uploader.services;

import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.docviewer.DocviewerClient;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentUtils;
import ru.yandex.inside.passport.PassportUidOrZero;

public class DocviewerApi implements ServiceApi {
    private DocviewerClient docviewerClient;

    public DocviewerApi(DocviewerClient docviewerClient) {
        this.docviewerClient = docviewerClient;
    }

    @Override
    public ServicePublishResult publish(ChemodanFile file, Content content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Content download(ServiceFileId id) {
        return ContentUtils.ofUnknownType(docviewerClient.getSourceInternal(PassportUidOrZero.fromUid(id.uid), id.n));
    }

    @Override
    public ChemodanService getService() {
        return ChemodanService.DOCVIEWER;
    }
}
