package ru.yandex.chemodan.uploader.services;

import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.mail.MailClient;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class MailApi2 implements ServiceApi {
    private final MailClient mailClient;

    public MailApi2(MailClient mailClient) {
        this.mailClient = mailClient;
    }

    @Override
    public ServicePublishResult publish(ChemodanFile file, Content content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Content download(ServiceFileId id) {
        String mid = StringUtils.substringBefore(id.n, "/");
        String hid = StringUtils.substringAfter(id.n, "/");
        return mailClient.getAttachStream2(id.uid, mid, hid);
    }

    @Override
    public ChemodanService getService() {
        return ChemodanService.MAIL2;
    }
}
