package ru.yandex.chemodan.uploader.services;

import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentUtils;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;

/**
 * @author akirakozov
 */
public class MulcaApi implements ServiceApi {
    private final MulcaClient mulcaClient;

    public MulcaApi(MulcaClient mulcaClient) {
        this.mulcaClient = mulcaClient;
    }

    @Override
    public ServicePublishResult publish(ChemodanFile file, Content content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Content download(ServiceFileId id) {
        return ContentUtils.ofUnknownType(mulcaClient.download(MulcaId.fromSerializedString(id.n)));
    }

    @Override
    public ChemodanService getService() {
        return ChemodanService.MULCA;
    }
}
