package ru.yandex.chemodan.uploader.services;

import java.util.List;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.util.exception.PermanentFailureException;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author akirakozov
 * @author vavinov
 */
public class ServiceApis {
    private final MapF<ChemodanService, ServiceApi> servicesMap;

    public ServiceApis(List<ServiceApi> services) {
        this.servicesMap = Cf.toList(services).toMap(s -> Tuple2.tuple(s.getService(), s));
    }

    public Content download(ServiceFileId id, ChemodanService service) {
        try {
            ServiceApi api = dispatch(service);
            return api.download(id);
        } catch (HttpException e) {
            int statusCode = e.getStatusCode().getOrElse(0);
            if (HttpStatus.is4xx(statusCode)) {
                throw new PermanentFailureException(e.getMessage(), e);
            } else {
                throw ExceptionUtils.translate(e);
            }
        }
    }

    public ServicePublishResult publish(ChemodanFile file, Content content, ChemodanService service) {
        ServiceApi api = dispatch(service);
        return api.publish(file, content);
    }

    private ServiceApi dispatch(ChemodanService service) {
        return servicesMap.getOrThrow(service, "Unknown service: " + service);
    }

}
