package ru.yandex.chemodan.uploader.services;

import java.util.List;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.uploader.browser.BrowserApiMdsClient;
import ru.yandex.chemodan.uploader.browser.BrowserMdsContextConfiguration;
import ru.yandex.chemodan.uploader.docviewer.DocviewerClient;
import ru.yandex.chemodan.uploader.mail.MailClient;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.wmi.WmiClient;

/**
 * @author akirakozov
 */
@Configuration
@Import({BrowserMdsContextConfiguration.class})
public class ServiceApisContextConfiguration {

    @Bean
    public MailClient mailClient() {
        return new MailClient();
    }

    @Bean
    @OverridableValuePrefix("wmi")
    public HttpClientConfigurator wmiHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    @OverridableValuePrefix("onlyoffice")
    public HttpClientConfigurator onlyOfficeHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public WmiClient wmiClient(@Value("${uploader.wmi.host-port}") String hostPort) {
        return new WmiClient(wmiHttpClientConfigurator().configure(), hostPort);
    }


    @Bean
    public ServiceApis serviceApis(List<ServiceApi> serviceApi) {
        return new ServiceApis(serviceApi);
    }

    @Bean
    public DocviewerApi docviewerApi(DocviewerClient docviewerClient) {
        return new DocviewerApi(docviewerClient);
    }

    @Bean
    public MulcaApi mulcaApi(MulcaClient mulcaClient) {
        return new MulcaApi(mulcaClient);
    }

    @Bean
    public BrowserApi browserApi(BrowserApiMdsClient browserApiMdsClient) {
        return new BrowserApi(browserApiMdsClient);
    }

    @Bean
    public MailApi2 mailApi2(MailClient mailClient) {
        return new MailApi2(mailClient);
    }

    @Bean
    public OnlyOfficeApi onlyOfficeApi(
            @Value("${uploader.onlyoffice.storage.host-port}") String storageHostPort,
            @Value("${uploader.onlyoffice.balancer.host-port}") String balancerHostPort)
    {
        return new OnlyOfficeApi(storageHostPort, balancerHostPort, onlyOfficeHttpClientConfigurator().configure());
    }
}
