package ru.yandex.chemodan.uploader.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author vavinov
 */
public class ServiceFileId extends DefaultObject {
    @JsonProperty
    public final PassportUid uid;
    @JsonProperty
    public final String n;  // service-specific identifier (XXX need more static typing)

    @JsonCreator
    public ServiceFileId(
            @JsonProperty("uid")
            PassportUid uid,
            @JsonProperty("n")
            String n)
    {
        this.uid = uid;
        this.n = n;
    }

    public String toSerializedString() {
        return uid.getUid() + ":" + n;
    }

    public static ServiceFileId valueOf(String s) {
        String uidPart = StringUtils.substringBefore(s, ":");
        String idPart = StringUtils.substringAfter(s, ":");
        return new ServiceFileId(PassportUid.cons(Long.parseLong(uidPart)), idPart);
    }
}
