package ru.yandex.chemodan.uploader.services;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.registry.record.status.ExifInfo.GeoCoords;

/**
 * @author nshmakov
 */
public class ServiceImageInfo extends ServiceFileInfo {
    @JsonProperty
    public final Option<GeoCoords> location;
    @JsonProperty
    public final Option<Instant> creationTime;

    public ServiceImageInfo(
            @JsonProperty("location") Option<GeoCoords> location,
            @JsonProperty("serviceFileUrl") String serviceFileUrl,
            @JsonProperty("creationTime") Option<Instant> creationTime)
    {
        super(serviceFileUrl);
        this.location = location;
        this.creationTime = creationTime;
    }
}
