package ru.yandex.chemodan.uploader.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.commune.uploader.util.http.IncomingFile;

/**
 * @author metal
 */
public class ServiceIncomingFile extends AbstractServiceIncomingFile {

    private final Option<ServiceFileInfo> serviceFileInfo;

    @JsonCreator
    public ServiceIncomingFile(
            @JsonProperty("incomingFile") IncomingFile incomingFile,
            @JsonProperty("serviceFileId") Option<ServiceFileId> serviceFileId,
            @JsonProperty("service") ChemodanService service,
            @JsonProperty("serviceImageInfo") Option<ServiceFileInfo> serviceFileInfo)
    {
        super(incomingFile, serviceFileId, service);
        this.serviceFileInfo = serviceFileInfo;
    }

    public Option<ServiceFileInfo> getServiceFileInfo() {
        return serviceFileInfo;
    }
}
