package ru.yandex.chemodan.uploader.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.commune.uploader.util.http.IncomingFile;

/**
 * @author akirakozov
 */
public class ServiceIncomingImage extends AbstractServiceIncomingFile {

    private final Option<ServiceImageInfo> serviceImageInfo;

    @JsonCreator
    public ServiceIncomingImage(
            @JsonProperty("incomingFile") IncomingFile incomingFile,
            @JsonProperty("serviceFileId") Option<ServiceFileId> serviceFileId,
            @JsonProperty("service") ChemodanService service,
            @JsonProperty("serviceImageInfo") Option<ServiceImageInfo> serviceImageInfo)
    {
        super(incomingFile, serviceFileId, service);
        this.serviceImageInfo = serviceImageInfo;
    }

    public Option<ServiceImageInfo> getServiceImageInfo() {
        return serviceImageInfo;
    }
}
