package ru.yandex.chemodan.uploader.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultToString;

/**
 * @author vavinov
 */
public class ServicePublishResult extends DefaultToString {
    @JsonProperty
    public final ServiceFileId serviceFileId;

    // XXX probably use something more typed (at least json/xml)
    @JsonProperty
    public final String serviceSpecificSummary;

    @JsonCreator
    public ServicePublishResult(
            @JsonProperty("serviceFileId") ServiceFileId serviceFileId,
            @JsonProperty("serviceSpecificSummary") String serviceSpecificSummary)
    {
        this.serviceFileId = serviceFileId;
        this.serviceSpecificSummary = serviceSpecificSummary;
    }
}
