package ru.yandex.chemodan.uploader.social;

import java.net.URI;

import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4InputStreamSource;

/**
 * @author nshmakov
 */
public class ExternalResourceClientImpl implements ExternalResourceClient {

    @Autowired
    @Qualifier("zoraHttpClient")
    private HttpClient externalResourceHttpClient;

    @Override
    public Content getContent(ChemodanService service, URI uri, Option<Boolean> disableRedirect) {
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeader("External-Service", service.name());

        if (disableRedirect.getOrElse(false)) {
            RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
            httpGet.setConfig(config);
        }

        return ContentUtils.ofUnknownType(new ApacheHttpClient4InputStreamSource(externalResourceHttpClient, httpGet));
    }
}
