package ru.yandex.chemodan.uploader.social;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;

import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.misc.thread.SemaphoreNotAvailableException;

/**
 * @author nshmakov
 */
public class ExternalResourceSemaphores {

    public final static String SEMAPHORES_PROPERTY = "uploader.stages.downloadedFileFromService2.semaphores.";
    public final static String DEFAULT_SEMAPHORES_PROPERTY =
            "uploader.stages.downloadedFileFromService2.semaphores.default";

    private Map<ChemodanService, Semaphore> semaphores;

    public ExternalResourceSemaphores(Properties properties) {
        semaphores = new HashMap<>();
        Integer defaultPermits = null;
        String defaultPermitsString = properties.getProperty(DEFAULT_SEMAPHORES_PROPERTY);
        if (defaultPermitsString != null) {
            defaultPermits = Integer.valueOf(defaultPermitsString);
        }

        for (ChemodanService service : ChemodanService.values()) {
            String value = properties.getProperty(SEMAPHORES_PROPERTY + service.name());
            if (value != null) {
                semaphores.put(service, new Semaphore(Integer.parseInt(value)));
            } else if (defaultPermits != null) {
                semaphores.put(service, new Semaphore(defaultPermits));
            }
        }
    }

    public ExternalResourceSemaphores(Map<ChemodanService, Semaphore> semaphores) {
        this.semaphores = semaphores;
    }

    public <T> T executeWithSemaphore(ChemodanService service, Function0<T> op) {
        Semaphore semaphore = semaphores.get(service);
        if (semaphore != null) { // if no semaphore is defined - execute without semaphore
            if (!semaphore.tryAcquire()) {
                throw new SemaphoreNotAvailableException("Too many uploads from " + service);
            }
            try {
                return op.apply();
            } finally {
                semaphore.release();
            }
        }
        return op.apply();
    }

    public <T> Function0<T> executeWithSemaphoreF(ChemodanService service, Function0<T> op) {
        return () -> executeWithSemaphore(service, op);
    }
}
