package ru.yandex.chemodan.uploader.social;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.uploader.registry.ExceptionDetails;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class SocialClientErrException extends RuntimeException implements ExceptionDetails {
    private final boolean invalidToken;

    public SocialClientErrException(Exception e) {
        this(e, false);
    }

    public SocialClientErrException(Exception e, boolean invalidToken) {
        super(e);
        this.invalidToken = invalidToken;
    }

    @Override
    public MapF<String, String> getDetails() {
        if (invalidToken) {
            return Cf.map("invalid_token", "true");
        }
        return Cf.map();
    }
}
