package ru.yandex.chemodan.uploader.social;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.mime.detect.MimeTypeDetector;

/**
 * @author nshmakov
 */
public class SocialDataFormatUtils {

    private static final ListF<String> JPEG_FORMATS = Cf.list("image/jpg", "image/jpeg");
    private static final String PNG_FORMAT = "image/png";
    private static final String MP4_FORMAT = "video/mp4";
    private static final String GIF_FORMAT = "image/gif";
    private static final ListF<String> ALLOWED_FORMATS =
            JPEG_FORMATS
            .plus1(PNG_FORMAT)
            .plus1(MP4_FORMAT)
            .plus1(GIF_FORMAT)
            ;

    /**
     * @return true if file is video
     */
    public static boolean checkDataFormat(InputStreamSource content) {
        String mimeType = detectMimeType(content);
        Check.isTrue(ALLOWED_FORMATS.containsTs(mimeType), "Unknown image format: " + mimeType);
        return mimeType.equals(MP4_FORMAT);
    }

    public static ImageFormat detectAndValidateDataFormat(InputStreamSource content) {
        String mimeType = detectMimeType(content);
        if (JPEG_FORMATS.containsTs(mimeType)) {
            return ImageFormat.JPEG;
        } else if (PNG_FORMAT.equals(mimeType)) {
            return ImageFormat.PNG;
        } else if (GIF_FORMAT.equals(mimeType)) {
            return ImageFormat.GIF;
        }  else {
            throw new IllegalArgumentException("Unknown image format: " + mimeType);
        }
    }

    private static String detectMimeType(InputStreamSource content) {
        return MimeTypeDetector.detect(Option.empty(), Option.of(content))
                .getOrThrow("Unknown image format").toLowerCase();
    }
}
