package ru.yandex.chemodan.uploader.social;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.uploader.social.SocialTaskInfo.FailReason;
import ru.yandex.chemodan.uploader.social.SocialTaskInfo.State;
import ru.yandex.chemodan.uploader.social.response.SocialProxyResponse;
import ru.yandex.chemodan.uploader.social.response.SocialProxyResponseParser;
import ru.yandex.chemodan.uploader.social.response.SocialUploadCommitResultResponse;
import ru.yandex.chemodan.uploader.social.response.SocialUploadCommitResultResponse.SocialPhotoIdResult;
import ru.yandex.chemodan.uploader.social.response.SocialUploadInfoResponse;
import ru.yandex.chemodan.uploader.social.response.SocialUploadInfoResponse.SocialUploadInfo;
import ru.yandex.chemodan.util.http.HttpClientUtils;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.ReadStringResponseHandler;
import ru.yandex.misc.lang.StringUtils;

/**
 * https://wiki.yandex-team.ru/social/proxy/v2#zagruzkafotokvsocialku
 *
 * @author akirakozov
 */
public class SocialProxyClient {
    private final String host;
    private final HttpClient httpClient;
    private final SocialProxyResponseParser parser = new SocialProxyResponseParser();

    private static final String uploadPhotoRequestPath = "/proxy2/profile/{}/photo_post/get_request";
    private static final String uploadPhotoCommitPath = "/proxy2/profile/{}/photo_post/commit";

    public SocialProxyClient(String host, HttpClient httpClient) {
        this.host = host;
        this.httpClient = httpClient;
        //this.httpClient = ApacheHttpClientUtils.multiThreadedHttpsClient(Timeout.seconds(10L), 20, "");
    }

    public SocialUploadInfo getPhotoUploadInfo(String profileId, String albumId) {
        String url = getUploadPhotoRequestUrl(profileId, albumId);
        SocialUploadInfoResponse response = parser.parseUploadInfoResponse(readStringResponse(new HttpGet(url)));
        return validateAndReturnResult(response);
    }

    public SocialPhotoIdResult commitPhotoUpload(String profileId, String albumdId, String uploadResponse) {
        String url = getUploadPhotoCommitUrl(profileId);
        HttpPost post = HttpClientUtils.httpPostMultipart(url,
                Cf.map("upload_response", uploadResponse, "aid", albumdId));
        SocialUploadCommitResultResponse response = parser.parseUploadCommitResponse(readStringResponse(post));
        return validateAndReturnResult(response);
    }

    String getUploadPhotoRequestUrl(String profileId, String albumId) {
        return UrlUtils.addParameter(
                getUrlMainPart() + StringUtils.format(uploadPhotoRequestPath, profileId),
                "aid", albumId);
    }

    String getUploadPhotoCommitUrl(String profileId) {
        return getUrlMainPart() + StringUtils.format(uploadPhotoCommitPath, profileId);
    }

    private String getUrlMainPart() {
        return "http://" + host;
    }

    private String readStringResponse(HttpUriRequest request) {
        try {
            return ApacheHttpClientUtils.execute(request, httpClient, new ReadStringResponseHandler());
        } catch (HttpException e) {
            if (HttpStatus.is4xx(e.getStatusCode().getOrElse(0))) {
                throw new SocialClientErrException(e);
            }
            throw e;
        }
    }

    private <T> T validateAndReturnResult(SocialProxyResponse<T> response) {
        if (response.getTaskInfo().getState() == State.SUCCESS) {
            return response.getResult().get();
        } else {
            FailReason reason = response.getTaskInfo().getReason().get();
            if (FailReason.ERR_CODE_RATE_LIMIT_EXCEEDED.equals(reason.getCode())) {
                throw new SocialProxyRetriableException(reason);
            } else {
                throw new SocialProxyException(reason);
            }
        }
    }

}
