package ru.yandex.chemodan.uploader.social;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.uploader.social.SocialTaskInfo.FailReason;
import ru.yandex.commune.uploader.registry.ExceptionDetails;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class SocialProxyException extends RuntimeException implements ExceptionDetails {
    private static final SetF<String> TOKEN_ERRORS = Cf.set(
            FailReason.ERR_CODE_INVALID_TOKEN,
            FailReason.ERR_CODE_NO_TOKENS_FOUND,
            FailReason.ERR_CODE_PERMISSION_ERROR);

    private final FailReason reason;

    public SocialProxyException(FailReason reason) {
        super(reason.getDescription() + " " + reason.getMessage());
        this.reason = reason;
    }

    public FailReason getReason() {
        return reason;
    }

    @Override
    public MapF<String, String> getDetails() {
        if (TOKEN_ERRORS.containsTs(reason.getCode())) {
            return Cf.map("invalid_token", "true");
        }
        return Cf.map();
    }
}
