package ru.yandex.chemodan.uploader.social;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.ByteArrayBody;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.uploader.social.response.SocialUploadInfoResponse;
import ru.yandex.chemodan.uploader.social.response.SocialUploadInfoResponse.SocialUploadInfo;
import ru.yandex.chemodan.util.http.HttpClientUtils;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

/**
 * @author akirakozov
 */
public class SocialProxyStages {
    private final Timeout uploadPhotoTimeout;
    private final SocialProxyClient socialProxyClient;

    public SocialProxyStages(SocialProxyClient socialProxyClient, Timeout timeout) {
        this.socialProxyClient = socialProxyClient;
        this.uploadPhotoTimeout = timeout;
    }

    public String uploadPhotoToSocialNet(String url, MapF<String, String> additionalParams,
            String fileParam, InputStreamSource file)
    {
       ImageFormat format = SocialDataFormatUtils.detectAndValidateDataFormat(file);
       HttpPost post = HttpClientUtils.httpPostMultipart(
                   url, additionalParams, fileParam,
                   new ByteArrayBody(
                           file.readBytes(),
                           ContentType.create(format.getContentType()),
                           "image." + format.getExtension())
               );

       return ApacheHttpClientUtils.execute(post, new SocialUploadResponseHandler(), uploadPhotoTimeout, true);
    }

    public Function0<String> uploadPhotoToScialNet(final SocialUploadInfo info, final File2 file) {
        return new Function0<String>() {
            public String apply() {
                return uploadPhotoToSocialNet(
                        info.getUploadUrl(), info.getAdditionalInfo(), info.getImagePathParamName(), file);
            }
        };
    }

    public Function0<SocialUploadInfo> getPhotoUploadInfo(final String profileId, final String albumId) {
        return new Function0<SocialUploadInfoResponse.SocialUploadInfo>() {
            public SocialUploadInfoResponse.SocialUploadInfo apply() {
                return socialProxyClient.getPhotoUploadInfo(profileId, albumId);
            }
        };
    }

    public Function0<Boolean> commitPhotoUpload(final String profileId, final String albumId,
            final String uploadResponse)
    {
        return new Function0<Boolean>() {
            public Boolean apply() {
                socialProxyClient.commitPhotoUpload(profileId, albumId, uploadResponse);
                return true;
            }
        };
    }
}
