package ru.yandex.chemodan.uploader.social;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 *
 * @author akirakozov
 */
@Bendable
public class SocialTaskInfo extends DefaultObject {
    @BenderPart(name = "profile_id", strictName = true)
    private final Option<Long> profileId;
    @BenderPart
    private final Option<String> provider;
    // TODO: make duration if necessary
    @BenderPart
    private final double runtime;
    @BenderPart
    private final State state;

    @BenderPart
    private final Option<FailReason> reason;

    @Bendable
    public enum State {
        SUCCESS,
        FAILURE,
        ;
    }

    @Bendable
    public static class FailReason extends DefaultObject {
        public static final String ERR_CODE_RATE_LIMIT_EXCEEDED = "rate_limit_exceeded";
        public static final String ERR_CODE_INVALID_TOKEN = "invalid_token";
        public static final String ERR_CODE_NO_TOKENS_FOUND = "no_tokens_found";
        public static final String ERR_CODE_PERMISSION_ERROR = "permission_error";
        @BenderPart
        private final String code;
        @BenderPart
        private final String description;
        @BenderPart
        private final String message;
        @BenderPart
        private final String type;

        public FailReason(String code, String description, String message, String type) {
            this.code = code;
            this.description = description;
            this.message = message;
            this.type = type;
        }

        public String getCode() {
            return code;
        }

        public String getDescription() {
            return description;
        }

        public String getMessage() {
            return message;
        }

        public String getType() {
            return type;
        }
    }

    public SocialTaskInfo(
            Option<Long> profileId, Option<String> provider,
            double runtime, State state, Option<FailReason> reason)
    {
        this.profileId = profileId;
        this.provider = provider;
        this.runtime = runtime;
        this.state = state;
        this.reason = reason;
    }

    public Option<Long> getProfileId() {
        return profileId;
    }

    public Option<String> getProvider() {
        return provider;
    }

    public double getRuntime() {
        return runtime;
    }

    public State getState() {
        return state;
    }

    public Option<FailReason> getReason() {
        return reason;
    }
}
