package ru.yandex.chemodan.uploader.social;

import java.io.IOException;

import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.serialize.JsonParser;
import ru.yandex.misc.io.InputStreamSourceUtils;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;


/**
 * @author akirakozov
 */
public class SocialUploadResponseHandler implements ResponseHandler<String> {
    private static final String OAUTH_EXCEPTION = "OAuthException";

    @Override
    public String handleResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (HttpStatus.is4xx(statusCode)) {
            boolean tokenError = isFacebookTokenError(readContent(response));
            throw new SocialClientErrException(createHttpException(response, statusCode), tokenError);
        } else if (statusCode != HttpStatus.SC_200_OK && statusCode != HttpStatus.SC_201_CREATED) {
            throw createHttpException(response, statusCode);
        }
        return readContent(response);
    }

    boolean isFacebookTokenError(String content) {
        if (!content.isEmpty()) {
            try {
                JsonObject resp = (JsonObject) JsonParser.getInstance().parse(content);
                JsonObject error = ((JsonObject) resp.get("error"));
                String type = ((JsonString) error.get("type")).getString();
                return OAUTH_EXCEPTION.equals(type);
            } catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private HttpException createHttpException(HttpResponse response, int statusCode) {
        return new HttpException(statusCode, "got error: " + response.getStatusLine());
    }

    private String readContent(HttpResponse response) throws IOException {
        return InputStreamSourceUtils.wrap(response.getEntity().getContent()).readText("utf-8");
    }
}
