package ru.yandex.chemodan.uploader.social.response;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.social.SocialTaskInfo;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * https://wiki.yandex-team.ru/social/proxy/v2#zagruzkafotokvsocialku
 *
 * @author akirakozov
 */
@Bendable
public abstract class SocialProxyResponse<T> extends DefaultObject {
    @BenderPart(name = "task")
    private final SocialTaskInfo taskInfo;

    public SocialProxyResponse(SocialTaskInfo taskInfo) {
        this.taskInfo = taskInfo;
    }

    public SocialTaskInfo getTaskInfo() {
        return taskInfo;
    }

    public abstract Option<T> getResult();

}
