package ru.yandex.chemodan.uploader.social.response;

import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.parse.BenderParser;

/**
 * https://wiki.yandex-team.ru/social/proxy/v2#zagruzkafotokvsocialku
 *
 * @author akirakozov
 */
public class SocialProxyResponseParser {
    private static BenderParser<SocialUploadInfoResponse> uploadInfoParser =
            Bender.cons(SocialUploadInfoResponse.class).getParser();
    private static BenderParser<SocialUploadCommitResultResponse> uploadCommitParser =
            Bender.cons(SocialUploadCommitResultResponse.class).getParser();

    public SocialUploadInfoResponse parseUploadInfoResponse(String response) {
        return uploadInfoParser.parseJson(response);
    }

    public SocialUploadCommitResultResponse parseUploadCommitResponse(String response) {
        return uploadCommitParser.parseJson(response);
    }

}
