package ru.yandex.chemodan.uploader.social.response;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.social.SocialTaskInfo;
import ru.yandex.chemodan.uploader.social.response.SocialUploadCommitResultResponse.SocialPhotoIdResult;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * https://wiki.yandex-team.ru/social/proxy/v2#zagruzkafotokvsocialku
 *
 * @author akirakozov
 */
@Bendable
public class SocialUploadCommitResultResponse extends SocialProxyResponse<SocialPhotoIdResult> {
    @BenderPart(name = "result")
    private final Option<SocialPhotoIdResult> result;

    @Bendable
    public static class SocialPhotoIdResult extends DefaultObject {
        @BenderPart(name = "pid")
        private final String photoId;

        public SocialPhotoIdResult(String photoId) {
            this.photoId = photoId;
        }

        public String getPhotoId() {
            return photoId;
        }
    }

    public SocialUploadCommitResultResponse(SocialTaskInfo taskInfo, Option<SocialPhotoIdResult> result) {
        super(taskInfo);
        this.result = result;
    }

    @Override
    public Option<SocialPhotoIdResult> getResult() {
        return result;
    }

}
