package ru.yandex.chemodan.uploader.social.response;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.social.SocialTaskInfo;
import ru.yandex.chemodan.uploader.social.response.SocialUploadInfoResponse.SocialUploadInfo;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * https://wiki.yandex-team.ru/social/proxy/v2#zagruzkafotokvsocialku
 *
 * @author akirakozov
 */
@Bendable
public class SocialUploadInfoResponse extends SocialProxyResponse<SocialUploadInfo> {
    @BenderPart(name = "result")
    private final Option<SocialUploadInfo> result;

    @Bendable
    public static class SocialUploadInfo extends DefaultObject {
        @JsonProperty
        @BenderPart(name = "url")
        private final String uploadUrl;

        @JsonProperty
        @BenderPart(name = "image_name", strictName = true)
        private final String imagePathParamName;

        @JsonProperty
        @BenderPart(name = "additional_POST", strictName = true)
        private final MapF<String, String> additionalInfo;

        public SocialUploadInfo(
                @JsonProperty("uploadUrl") String uploadUrl,
                @JsonProperty("imagePathParamName") String imagePathParamName,
                @JsonProperty("additionalInfo") MapF<String, String> additionalInfo)
        {
            this.uploadUrl = uploadUrl;
            this.imagePathParamName = imagePathParamName;
            this.additionalInfo = additionalInfo;
        }

        public String getUploadUrl() {
            return uploadUrl;
        }

        public String getImagePathParamName() {
            return imagePathParamName;
        }

        public MapF<String, String> getAdditionalInfo() {
            return additionalInfo;
        }
    }

    public SocialUploadInfoResponse(SocialTaskInfo taskInfo, Option<SocialUploadInfo> result) {
        super(taskInfo);
        this.result = result;
    }

    @Override
    public Option<SocialUploadInfo> getResult() {
        return result;
    }

}
