package ru.yandex.chemodan.uploader.stage;

import org.joda.time.Instant;

import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.uploader.log.Events;
import ru.yandex.chemodan.uploader.log.StageInfo;
import ru.yandex.commune.uploader.log.Event;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.TimeUtils;

/**
 * @author akirakozov
 */
public class LoggableStageProcessor implements StageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(LoggableStageProcessor.class);

    public <T> T process(String taskName, String stageName, Function0<T> stage) {
        return processStage(taskName, stageName, stage);
    }

    public static <T> T processStage(String taskName, String stageName, Function0<T> stage) {
        final Instant startTime = new Instant();
        StageInfo info = new StageInfo(taskName, stageName);
        try {
            T result = stage.apply();
            Events.log(info, Event.success(TimeUtils.toDurationToNow(startTime), result));
            return result;
        } catch (Exception e) {
            logger.warn(e, e);
            Events.log(info, Event.failure(TimeUtils.toDurationToNow(startTime), e.getMessage()));
            throw ExceptionUtils.translate(e);
        }
    }
}
