package ru.yandex.chemodan.uploader.status;

import java.util.List;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategy;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author nshmakov
 */
public class LoadingStatusManager {

    private static final Logger logger = LoggerFactory.getLogger(LoadingStatusManager.class);

    private MapF<LoadingStatusStrategyType, LoadingStatusStrategy> loadingStatusStrategies;

    @Autowired
    public void setLoadingStatusStrategies(List<LoadingStatusStrategy> loadingStatusStrategies) {
        this.loadingStatusStrategies = Cf.wrap(loadingStatusStrategies).toMapMappingToKey(
                new Function<LoadingStatusStrategy, LoadingStatusStrategyType>() {
                    public LoadingStatusStrategyType apply(LoadingStatusStrategy loadingStatusStrategy) {
                        return loadingStatusStrategy.getType();
                    }
                });
    }

    @PostConstruct
    public void logLoadingStatusStrategies() {
        logger.info("Enabled loading status strategies: " + loadingStatusStrategies.keys().mkString(","));
    }

    public MapF<LoadingStatusStrategyType, Long> computeLoadingStatus() {
        MapF<LoadingStatusStrategyType, Long> result = Cf.hashMap();
        loadingStatusStrategies.forEach((type, strategy) -> result.put(type, strategy.compute()));
        return result;
    }
}
