package ru.yandex.chemodan.uploader.status;

import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.util.ping.PingerChecker;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author nshmakov
 * @author metal
 */
public class LogsFreeSizeChecker implements PingerChecker {

    private static final Logger logger = LoggerFactory.getLogger(LogsFreeSizeChecker.class);

    @Value("${local.file.manager.dir}")
    private File2 localFilesDir;

    @Value("${uploader.ping.min.free.space}")
    private DataSize minFreeSpace;

    public boolean isAvailable() {
        return isEnoughFreeSpace();
    }

    private boolean isEnoughFreeSpace() {
        DataSize freeSpace = localFilesDir.getFreeSpaceSize();
        if (freeSpace.ge(minFreeSpace)) {
            return true;
        } else {
            logger.error("not enough free space: %s < %s", freeSpace.toPrettyString(), minFreeSpace.toPrettyString());
            return false;
        }
    }

    void setLocalFilesDir(File2 localFilesDir) {
        this.localFilesDir = localFilesDir;
    }

    void setMinFreeSpace(DataSize minFreeSpace) {
        this.minFreeSpace = minFreeSpace;
    }

    @Override
    public boolean isActive() {
        return isAvailable();
    }
}
