package ru.yandex.chemodan.uploader.status;

import ru.yandex.chemodan.util.ping.PingerChecker;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.version.AppName;

/**
 * @author metal
 */
public class MaintenanceFileChecker implements PingerChecker {
    private static final String MAINTENANCE_FILE_PATH_TEMPLATE = "/var/lib/yandex/%s/%s/maintenance.file";

    private final File2 file;

    public MaintenanceFileChecker(AppName appName) {
        this.file = new File2(String.format(MAINTENANCE_FILE_PATH_TEMPLATE, appName.serviceName(), appName.appName()));
    }

    public MaintenanceFileChecker(File2 file) {
        this.file = file;
    }

    public boolean exists() {
        return file.exists();
    }

    @Override
    public boolean isActive() {
        return !exists();
    }
}
