package ru.yandex.chemodan.uploader.status.strategy;

import javax.annotation.PostConstruct;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.uploader.status.strategy.utils.DeviceStatUtils;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author nshmakov
 */
public class DiskIoBasedStrategy extends DelayingWorkerServiceBeanSupport implements LoadingStatusStrategy {

    private static final Logger logger = LoggerFactory.getLogger(DiskIoBasedStrategy.class);

    private File2 statFile;
    private String deviceName;
    private int sectorSize;

    private long lastSectorsStat = 0;
    private volatile long currentDiskIo = 0;

    @PostConstruct
    public void postConstruct() {
        logger.info("DiskIoBasedStrategy initialized with params: statFile={}, deviceName={}, sectorSize={}",
                statFile, deviceName, sectorSize);
    }

    @Override
    public LoadingStatusStrategyType getType() {
        return LoadingStatusStrategyType.DISK_IO;
    }

    @Override
    public long compute() {
        return currentDiskIo;
    }

    @Override
    protected void execute() throws Exception {
        refresh();
    }

    public void refresh() {
        ListF<String> stats = statFile.readLines();
        String[] diskIoStatString = DeviceStatUtils.getDeviceStat(deviceName, stats).split(" ");
        long currentDiskSectorsRead = Long.parseLong(diskIoStatString[5]);
        long currentDiskSectorsWritten = Long.parseLong(diskIoStatString[9]);
        long currentSectorsStat = currentDiskSectorsRead + currentDiskSectorsWritten;
        if (lastSectorsStat != 0) {
            currentDiskIo = (currentSectorsStat - lastSectorsStat) * sectorSize;
        }
        lastSectorsStat = currentSectorsStat;
    }

    public void setStatFile(File2 statFile) {
        this.statFile = statFile;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setSectorSize(int sectorSize) {
        this.sectorSize = sectorSize;
    }
}
