package ru.yandex.chemodan.uploader.status.strategy;

import javax.annotation.PostConstruct;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.uploader.status.strategy.utils.DeviceStatUtils;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author nshmakov
 */
public class DiskIopsBasedStrategy extends DelayingWorkerServiceBeanSupport implements LoadingStatusStrategy {

    private static final Logger logger = LoggerFactory.getLogger(DiskIopsBasedStrategy.class);

    private File2 statFile;
    private String deviceName;

    private long lastDiskIops = 0;
    private volatile long currentDiskIopsDelta = 0;

    @PostConstruct
    public void postConstruct() {
        logger.info("DiskIopsBasedStrategy initialized with params: statFile={}, deviceName={}", statFile, deviceName);
    }

    @Override
    public LoadingStatusStrategyType getType() {
        return LoadingStatusStrategyType.DISK_IOPS;
    }

    @Override
    public long compute() {
        return currentDiskIopsDelta;
    }

    @Override
    protected void execute() throws Exception {
        refresh();
    }

    public void refresh() {
        ListF<String> stats = statFile.readLines();
        String[] fullDeviceStat = DeviceStatUtils.getDeviceStat(deviceName, stats).split(" ");
        long readOps = Long.parseLong(fullDeviceStat[3]);
        long writeOps = Long.parseLong(fullDeviceStat[7]);
        long currentDiskIops = (readOps + writeOps);
        if (lastDiskIops != 0) {
            currentDiskIopsDelta = currentDiskIops - lastDiskIops;
        }
        lastDiskIops = currentDiskIops;
    }

    public void setStatFile(File2 statFile) {
        this.statFile = statFile;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }
}
