package ru.yandex.chemodan.uploader.status.strategy;

import lombok.Data;

import ru.yandex.chemodan.uploader.registry.QueueSensors;

@Data
public class ExponentialUserQueueInProgressLoadingStatusStrategy implements LoadingStatusStrategy {

    private final QueueSensors queueSensors;

    @Override
    public LoadingStatusStrategyType getType() {
        return LoadingStatusStrategyType.EXP_USER_QUEUE_IN_PROGRESS;
    }

    @Override
    public long compute() {
        try {
            return (long) queueSensors.exponentialWeightInProgress();
        } catch (RuntimeException e) {
            return 0;
        }
    }
}
