package ru.yandex.chemodan.uploader.status.strategy;

import lombok.Data;

import ru.yandex.chemodan.uploader.registry.QueueSensors;

@Data
public class ExponentialUserQueueInitialLoadingStatusStrategy implements LoadingStatusStrategy {

    private final QueueSensors queueSensors;

    @Override
    public LoadingStatusStrategyType getType() {
        return LoadingStatusStrategyType.EXP_USER_QUEUE_INITIAL;
    }

    @Override
    public long compute() {
        try {
            return (long) queueSensors.exponentialWeightInitial();
        } catch (RuntimeException e) {
            return 0;
        }
    }
}
