package ru.yandex.chemodan.uploader.status.strategy;

import java.lang.management.OperatingSystemMXBean;

/**
 * @author nshmakov
 */
public class LaBasedStrategy implements LoadingStatusStrategy {

    private OperatingSystemMXBean operatingSystemMXBean;

    @Override
    public long compute() {
        return (long) (operatingSystemMXBean.getSystemLoadAverage() * 100);
    }

    @Override
    public LoadingStatusStrategyType getType() {
        return LoadingStatusStrategyType.LA;
    }

    public void setOperatingSystemMXBean(OperatingSystemMXBean operatingSystemMXBean) {
        this.operatingSystemMXBean = operatingSystemMXBean;
    }
}
