package ru.yandex.chemodan.uploader.status.strategy;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import ru.yandex.misc.enums.EnumResolver;

/**
 * @author nshmakov
 */
public enum LoadingStatusStrategyType {

    LA,
    CONTENT,
    DISK_IO,
    DISK_IOPS,
    NETWORK_IO,
    QUEUE_SIZE_USER,
    EXP_USER_QUEUE_INITIAL,
    EXP_USER_QUEUE_IN_PROGRESS,
    QUEUE_SIZE_MULCA,
    ;

    public static EnumResolver<LoadingStatusStrategyType> R = EnumResolver.er(LoadingStatusStrategyType.class);

    public static List<LoadingStatusStrategyType> fromString(String types) {
        return Stream.of(types.split(","))
                .map(LoadingStatusStrategyType.R::valueOf)
                .collect(Collectors.toList());
    }
}
