package ru.yandex.chemodan.uploader.status.strategy;

import lombok.Data;

import ru.yandex.chemodan.uploader.registry.QueueSensors;

@Data
public class MulcaQueueSizeLoadingStatusStrategy implements LoadingStatusStrategy {

    private final QueueSensors queueSensors;

    @Override
    public LoadingStatusStrategyType getType() {
        return LoadingStatusStrategyType.QUEUE_SIZE_MULCA;
    }

    @Override
    public long compute() {
        return queueSensors.incompleteAndUploadedLocallyAndNotUploadedToMulca();
    }
}
