package ru.yandex.chemodan.uploader.status.strategy;

import lombok.Data;

import ru.yandex.chemodan.uploader.registry.QueueSensors;

@Data
public class UserQueueSizeLoadingStatusStrategy implements LoadingStatusStrategy {

    private final QueueSensors queueSensors;

    @Override
    public LoadingStatusStrategyType getType() {
        return LoadingStatusStrategyType.QUEUE_SIZE_USER;
    }

    @Override
    public long compute() {
        return queueSensors.incompleteRequestsWaitingForUserCount();
    }
}
