package ru.yandex.chemodan.uploader.status.strategy.utils;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.exec.ExecResult;
import ru.yandex.misc.io.exec.ExecUtils;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author nshmakov
 * @author akirakozov
 */
public class DiskDeviceLinuxUtils {
    private static final Logger logger = LoggerFactory.getLogger(DiskDeviceLinuxUtils.class);

    public static String getDeviceNameForFile(String filePath) {
        ExecResult result = ExecUtils.executeGrabbingOutput("df", filePath);
        Check.isTrue(result.isSuccess(), "df exited with error code");
        return parseDeviceName(result.getOutput());
    }

    /**
     * Parse device name from output like this
     * Filesystem      1K-blocks     Used  Available Use% Mounted on
     * /dev/md1       1716312332 51731224 1664581108   4% /u0
     */
    private static String parseDeviceName(String output) {
        try {
            String fileSystem = output.split("\n")[1].split(" ")[0];
            return fileSystem.split("/")[2];
        } catch (Exception ex) {
            throw ExceptionUtils.translate(ex, "Cannot parse df report " + output);
        }
    }

    public static int getDeviceSectorSize(String device) {
        try {
            return getDeviceSectorSizeInner(device);
        } catch (Exception e) {
            logger.debug("Couldn't get sector size for {}, error: {}", device, e.getMessage());
            String shortName = getDeviceShortName(device);
            logger.debug("Try short name {}", shortName);
            return getDeviceSectorSizeInner(shortName);
        }
    }

    private static int getDeviceSectorSizeInner(String device) {
        String sectorSizeString = new File2("/sys/block/" + device + "/queue/hw_sector_size").readFirstLine();
        return Integer.parseInt(sectorSizeString);
    }

    public static String getDeviceShortName(String device) {
        int i = 0;
        while (i < device.length() && ('0' > device.charAt(i) || device.charAt(i) > '9')) {
            i++;
        }
        return device.substring(0, i);
    }
}
