package ru.yandex.chemodan.uploader.status.strategy.utils;

import ru.yandex.misc.io.exec.ExecResult;
import ru.yandex.misc.io.exec.ExecUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author nshmakov
 */
public class NetworkInterfaceLinuxUtils {

    private static final String DEFAULT_ACTIVE_NETWORK_INTERFACE = "eth0";
    private static final String DETECTOR = "/usr/bin/detect-active-network-interface.sh";

    private static final Logger logger = LoggerFactory.getLogger(NetworkInterfaceLinuxUtils.class);

    public static String detectActiveNetworkInterface() {
        ExecResult result = ExecUtils.executeGrabbingOutput(DETECTOR);
        if (result.isSuccess() && StringUtils.isNotEmpty(result.getOutput())) {
            String activeNetworkInterface = result.getStdout().trim();
            logger.info("Active network interface detected: {}", activeNetworkInterface);
            return activeNetworkInterface;
        } else {
            logger.info("Can't detect active network interface using detect-active-network-interface.sh. " +
                    "Use default: {}", DEFAULT_ACTIVE_NETWORK_INTERFACE);
            return DEFAULT_ACTIVE_NETWORK_INTERFACE;
        }
    }

}
