package ru.yandex.chemodan.uploader.util;

import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpPut;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.util.http.HttpClientUtils;
import ru.yandex.commune.uploader.util.http.HttpContentRange;
import ru.yandex.misc.lang.Validate;

/**
 * @author vpronto
 */
public class UploaderHttpClientUtils extends HttpClientUtils {

    public static HttpPut httpPutZippedAndRanged(String uri, byte[] data, int from, int to, int total) {
        MapF<String, String> headers = Cf.map(
                HttpHeaders.CONTENT_ENCODING, "gzip",
                "Content-Range", new HttpContentRange(from, to, total).toString());
        return httpPut(uri, data, headers, true);
    }

    public static HttpPut httpPutRanged(String uri, byte[] data, int from, int to, int total) {
        Validate.V.isTrue(data.length == to - from + 1);
        return httpPut(uri, data, Cf.map("Content-Range", new HttpContentRange(from, to, total).toString()));
    }

}
