package ru.yandex.chemodan.uploader.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.boot.ChemodanInitContextConfiguration;
import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.UidOrSpecial;
import ru.yandex.chemodan.uploader.UploaderPorts;
import ru.yandex.chemodan.uploader.config.UploaderControlDaemonContextConfiguration;
import ru.yandex.chemodan.uploader.config.UploaderCoreContextConfiguration;
import ru.yandex.chemodan.uploader.config.UploaderCoreContextConfigurationForTests;
import ru.yandex.chemodan.uploader.config.UploaderDataDaemonContextConfiguration;
import ru.yandex.chemodan.uploader.config.UploaderDataWorkerContextConfiguration;
import ru.yandex.chemodan.uploader.log.UploaderLog4jHelper;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.web.client.UploaderClient;
import ru.yandex.chemodan.uploader.web.data.CrossdomainXmlServlet;
import ru.yandex.chemodan.util.http.HttpClientUtils;
import ru.yandex.chemodan.util.ping.CoolPingServlet;
import ru.yandex.chemodan.util.test.AbstractTest;
import ru.yandex.commune.uploader.local.queue.LocalQueueProcessor;
import ru.yandex.commune.uploader.local.queue.LocalRequestQueue;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.registry.UploadRequestStatus;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.env.Environment;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.thread.ThreadUtils;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author vavinov
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {
        ChemodanInitContextConfiguration.class,
        UploaderCoreContextConfigurationForTests.class,
        UploaderDataWorkerContextConfiguration.class})
public class AbstractWebTestSupport extends AbstractTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWebTestSupport.class);

    @Value("${hashishin.dir}")
    private File2 recordsDir;
    @Value("${hashishin.dir.done}")
    private File2 doneRecordsDir;
    @Value("${control.socket.maxIdleTime}")
    private Duration maxIdleTime;

    @Autowired
    protected UploaderPorts uploaderHttpPorts;
    @Autowired
    protected MulcaClient mulcaClient;
    @Autowired
    protected UploaderDataWorkerContextConfiguration uploaderDataWorkerContextConfiguration;
    @Autowired
    protected UploaderCoreContextConfiguration uploaderCoreContextConfiguration;
    @Autowired
    protected LocalQueueProcessor localQueueProcessor;
    @Autowired
    protected LocalRequestQueue localRequestQueue;
    @Autowired
    protected UploadRegistry<MpfsRequestRecord> uploadRegistry;
    @Autowired
    private CrossdomainXmlServlet crossdomainXmlServlet;

    protected SingleWarJetty controlJetty;
    protected SingleWarJetty dataJetty;

    protected static final ChemodanFile CHE_FILE =
            ChemodanFile.cons(UidOrSpecial.uid(PassportUid.cons(16011578)), "123", "/foo");

    @Before
    public void before() {
        //org.apache.log4j.Logger.getLogger("org.eclipse.jetty").setLevel(Level.DEBUG);
        UploaderLog4jHelper.configureUploaderExLogging();

        controlJetty = new UploaderControlDaemonContextConfiguration()
                .controlJetty(10, 10, maxIdleTime, uploaderHttpPorts, uploaderCoreContextConfiguration);
        dataJetty = new UploaderDataDaemonContextConfiguration()
                .dataJetty(10, 10, "", "", "", Duration.standardMinutes(1), uploaderHttpPorts,
                        uploaderCoreContextConfiguration, uploaderDataWorkerContextConfiguration,
                        uploadRegistry, crossdomainXmlServlet, new CoolPingServlet(Cf.list()));

        controlJetty.start();
        dataJetty.start();

        localRequestQueue.setEnabled(true);
        localRequestQueue.start();
        localQueueProcessor.setEnabled(true);
        localQueueProcessor.start();
    }

    @After
    public void after() {
        localQueueProcessor.stop();
        localRequestQueue.stop();

        this.dataJetty.stop();
        this.controlJetty.stop();
    }

    protected UploaderClient newUploaderClient() {
        return new UploaderClient(
                "http://localhost:" + uploaderHttpPorts.getControlPort(),
                getHttpClientTimeout());
    }

    protected static Timeout getHttpClientTimeout() {
        return Timeout.seconds(Environment.isDeveloperNotebook() ? 0 : 5);
    }

    public static Element pollStatusUntilCompleted(HttpClient client, String statusXmlUri) {
        for (;;) {
            Element statusXml = HttpClientUtils.parseXmlResponse(client, new HttpGet(statusXmlUri));
            String s = statusXml.attributeValue("status");
            if (s.equals(UploadRequestStatus.Result.COMPLETED.name().toLowerCase())) {
                return statusXml;
            }
            Check.C.equals(UploadRequestStatus.Result.PROCESSING.name().toLowerCase(), s);
            ThreadUtils.sleep(1000);
            logger.info(statusXml.asXML());
        }
    }

    public static Element pollStatusUntilFinished(HttpClient client, String statusXmlUri) {
        for (;;) {
            Element statusXml = HttpClientUtils.parseXmlResponse(client, new HttpGet(statusXmlUri));
            String s = statusXml.attributeValue("status");
            if (s.equals(UploadRequestStatus.Result.PROCESSING.name().toLowerCase())) {
                ThreadUtils.sleep(1000);
                logger.info(statusXml.asXML());
            } else {
                return statusXml;
            }
        }
    }

    public static Option<String> attributeValue(Node a) {
        return a == null ? Option.empty() : Option.of(((Attribute) a).getValue());
    }

    public static Option<MulcaId> patchInfoDiskFileId(Element uploadInfo) {
        return attributeValue(uploadInfo
                .selectSingleNode("/patch-info/stages/mulca-file/result/@mulca-id"))
                .map(MulcaId::fromSerializedString);
    }

    public static void executeWithNetworkFail(HttpClient client, HttpUriRequest request)
        throws Exception
    {
        try {
            client.execute(request);
        } catch (SuddenNetworkFailException ignored) {
            return;
        }
        Check.C.fail("expected " + SuddenNetworkFailException.class);
    }

    public static class SuddenNetworkFailException extends RuntimeException {
    }

    public static HttpPut httpPutPartial(String uri, final byte[] data,
            final int declaredContentLength)
    {
        HttpPut put = new HttpPut(uri);
        put.setEntity(new AbstractHttpEntity() {
            @Override
            public boolean isRepeatable() {
                return false;
            }
            @Override
            public long getContentLength() {
                return declaredContentLength;
            }
            @Override
            public InputStream getContent() throws IOException, IllegalStateException {
                return null;
            }
            @Override
            public void writeTo(OutputStream outstream) throws IOException {
                outstream.write(data);
                outstream.flush();
                throw new SuddenNetworkFailException();
            }
            @Override
            public boolean isStreaming() {
                return false;
            }
        });
        return put;
    }

}
