package ru.yandex.chemodan.uploader.web;

import javax.servlet.http.HttpServletRequest;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 *
 * @author akirakozov
 */
public class UploadTimeoutHolder {
    private static final Logger logger = LoggerFactory.getLogger(UploadTimeoutHolder.class);
    private static final String YANDEX_DISK_UA_PREFIX = "Yandex.Disk";

    final static String COMPLETE_UPLOAD_HEADER = "X-Disk-Uploader-Wait-Complete-Upload";

    @Value("${uploader.servlet.commit.upload.external.wait.delay}")
    private Duration waitCommitFileUploadExternalTimeout;
    @Value("${uploader.servlet.commit.upload.max.wait.delay}")
    private Duration waitCommitFileUploadMaxTimeout;
    @Value("${uploader.servlet.commit.upload.min.wait.delay}")
    private Duration waitCommitFileUploadMinTimeout;

    public UploadTimeoutHolder(Duration extenalClientsTimeout, Duration maxTimeout, Duration minTimeout) {
        waitCommitFileUploadExternalTimeout = extenalClientsTimeout;
        waitCommitFileUploadMaxTimeout = maxTimeout;
        waitCommitFileUploadMinTimeout = minTimeout;
    }

    public Duration getWaitCommitFileUploadTimeout(boolean max, boolean ourClient) {
        if (!ourClient) {
            return waitCommitFileUploadExternalTimeout;
        }
        return max ? waitCommitFileUploadMaxTimeout : waitCommitFileUploadMinTimeout;
    }

    /**
     * https://st.yandex-team.ru/CHEMODAN-33913
     * Some clients dislike wait long timeout (18 minutes), such clients should use special headers
     * to avoid using of long timeout.
     */
    public Duration getUploadTimeout(HttpServletRequest req) {
        HttpServletRequestX reqX = HttpServletRequestX.wrap(req);

        boolean completeParam = true;
        if (!reqX.getQueryString2().isEmpty()) {
            completeParam = UrlUtils.urlParametersToTuple2List(reqX.getQueryString2())
                    .toMap().getO("wait-complete-upload")
                    .map(Boolean::parseBoolean).getOrElse(true);
        }

        boolean completeHeader = reqX.getHeaderO(COMPLETE_UPLOAD_HEADER)
               .map(Boolean::parseBoolean).getOrElse(true);

        return getWaitCommitFileUploadTimeout(completeHeader && completeParam, isOurClient(reqX));
    }

    static boolean isOurClient(HttpServletRequestX reqX) {
        try {
            return reqX.getUserAgent().getOrElse("").contains(YANDEX_DISK_UA_PREFIX)
                    || reqX.getHeaderO("Origin").exists(origin -> origin.contains(".yandex."));
        } catch (Throwable e) {
            ExceptionUtils.throwIfUnrecoverable(e);
            logger.error("Failed to check out client: {}", e);
        }
        return false;
    }
}
