package ru.yandex.chemodan.uploader.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
@BenderBindAllFields
public class YaDiskUserAgent extends DefaultObject {
    public static final BenderParserSerializer<YaDiskUserAgent> PS = Bender.cons(
            YaDiskUserAgent.class, BenderConfiguration.defaultConfiguration());

    public final String os;
    @BenderPart(name = "vsn", strictName = true)
    public final String version;
    public final String id;
    @BenderPart(name = "src", strictName = true)
    public final Option<String> source;
    public final Option<String> device;

    public YaDiskUserAgent(
            String os, String version, String id,
            Option<String> source, Option<String> device)
    {
        this.os = os;
        this.version = version;
        this.id = id;
        this.source = source;
        this.device = device;
    }

    public static Option<YaDiskUserAgent> parse(String userAgent) {
        String jsonPart = StringUtils.substringAfter(userAgent, "Yandex.Disk ");
        try {
            return Option.of(PS.getParser().parseJson(jsonPart));
        } catch (Exception e) {
            return Option.empty();
        }
    }
}
