package ru.yandex.chemodan.uploader.web.control;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author akirakozov
 */
public class BannedDomainProxySettingsImpl implements  BannedDomainsProxySettings {
    private final DynamicProperty<ListF<String>> bannedDomains =
            DynamicProperty.cons("uploader-banned-domains", Cf.list());
    private final DynamicProperty<String> proxyHost =
            DynamicProperty.cons("uploader-proxy-for-banned-domains", "disk.yandex.ua");


    @Override
    public boolean isBannedDomain(String tld) {
        return bannedDomains.get().containsTs(tld);
    }

    @Override
    public String getProxyHost() {
        return proxyHost.get();
    }
}
