package ru.yandex.chemodan.uploader.web.control;

import java.io.OutputStream;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.UploaderHosts;
import ru.yandex.chemodan.uploader.UploaderPorts;
import ru.yandex.chemodan.uploader.web.ApiPrivateUrls;
import ru.yandex.commune.uploader.registry.RequestRecord;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.xml.stream.JavolutionXmlWriter;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author vavinov
 */
public class ControlResponseXmlizer {
    private final boolean dataSslUrls;
    private final UploaderHosts uploaderHosts;
    private final UploaderPorts uploaderHttpPorts;
    private final BannedDomainsProxySettings bannedDomainsProxySettings;

    public ControlResponseXmlizer(UploaderHosts uploaderHosts,
            UploaderPorts uploaderHttpPorts, BannedDomainsProxySettings bannedDomainsProxySettings,
            boolean dataSslUrls)
    {
        this.dataSslUrls = dataSslUrls;
        this.uploaderHosts = uploaderHosts;
        this.uploaderHttpPorts = uploaderHttpPorts;
        this.bannedDomainsProxySettings = bannedDomainsProxySettings;
    }

    private void writeInner(OutputStream out, String root, MapF<String, String> dataAttributeUris,
            RequestRecord record, Option<Boolean> useHttps, String additionalParams, Option<String> tld)
    {
        XmlWriter xw = new JavolutionXmlWriter(out, false, "\t");
        write(xw, root, dataAttributeUris, record, useHttps, additionalParams, tld);
        xw.flush();
        xw.close();
    }

    private void write(XmlWriter xw, String root, MapF<String, String> dataAttributeUris,
            RequestRecord record, Option<Boolean> useHttps, String additionalParams, Option<String> tld)
    {
        xw.startElement(root);

        xw.addAttribute("poll-result", "http://" + uploaderHosts.getSlbHost() +
                ":" + uploaderHttpPorts.getControlSlbPort() +
                ApiPrivateUrls.REQUEST_STATUS + "/" + record.meta.id.id);

        final String dataScheme;
        final int dataPort;
        if (useHttps.getOrElse(dataSslUrls)) {
            dataScheme = "https";
            dataPort = uploaderHttpPorts.getDataHttpsPort();
        } else {
            dataScheme = "http";
            dataPort = uploaderHttpPorts.getDataPort();
        }

        for (String attr : dataAttributeUris.keys()) {
            String url = getBaseUploadUrl(dataScheme, dataPort, record.lease.get().host.toString(),
                    dataAttributeUris.getTs(attr) + "/" + record.meta.id.id, tld);
            if (StringUtils.isNotBlank(additionalParams)) {
                url += "?" + additionalParams;
            }
            xw.addAttribute(attr, url);
        }
        xw.endElement();
    }

    private String getBaseUploadUrl(String dataScheme, int dataPort, String host, String path, Option<String> tld) {
        if (tld.isPresent() && bannedDomainsProxySettings.isBannedDomain(tld.get())
                && StringUtils.startsWith(host, "uploader"))
        {
            String uploaderPart = StringUtils.substringBefore(host, ".");
            return dataScheme + "://" + bannedDomainsProxySettings.getProxyHost() + ":" + dataPort +
                    "/upload/" + uploaderPart + path;
        } else {
            return dataScheme + "://" + host + ":" + dataPort + path;
        }
    }

    public void write(OutputStream out, String root, RequestRecord record) {
        writeInner(out, root, Cf.map(), record, Option.empty(), "", Option.empty());
    }

    public void write(OutputStream out, String root, RequestRecord record,
            MapF<String, String> dataAttributeUris, Option<Boolean> useHttps)
    {
        writeInner(out, root, dataAttributeUris, record, useHttps, "", Option.empty());
    }

    public void write(OutputStream out, String root, RequestRecord record,
            MapF<String, String> dataAttributeUris, Option<Boolean> useHttps, String additionalParams,
            Option<String> tld)
    {
        writeInner(out, root, dataAttributeUris, record, useHttps, additionalParams, tld);
    }


}
