package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.registry.ApiVersion;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecordUtils;
import ru.yandex.chemodan.uploader.services.ServiceFileId;
import ru.yandex.chemodan.uploader.services.ServiceFileInfo;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.commune.uploader.registry.RequestRecord;
import ru.yandex.commune.uploader.registry.RequestRevision;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.util.HostInstant;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpRequestUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author metal
 */
public class ConvertToMsOoxmlFormatServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ConvertToMsOoxmlFormatServlet.class);

    @Autowired
    private ControlResponseXmlizer controlResponseXmlizer;
    @Autowired
    private UploadRegistry<MpfsRequestRecord> uploadRegistry;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.info(HttpRequestUtils.describeRemoveSensitive(req));

        HttpServletRequestX reqX = HttpServletRequestX.wrap(req);
        RequestRecord record = createRecordFromRequest(reqX);

        resp.setContentType("application/xml");

        controlResponseXmlizer.write(resp.getOutputStream(), "convert-to-ms-ooxml-format", record);
    }

    private RequestRecord createRecordFromRequest(HttpServletRequestX reqX) {
        ChemodanService service = ChemodanService.R.valueOf(reqX.getRequiredParameter(ApiArgs.SOURCE_SERVICE));

        Option<ServiceFileId> serviceFileId;
        Option<ServiceFileInfo> serviceFileInfo;
        if (service.isExternal()) {
            String serviceFileUrl = reqX.getRequiredParameter(ApiArgs.SERVICE_FILE_URL);
            serviceFileInfo = Option.of(new ServiceFileInfo(serviceFileUrl));
            serviceFileId = Option.empty();
        } else {
            String rawServiceFileId = reqX.getRequiredParameter(ApiArgs.SERVICE_FILE_ID);
            serviceFileId = Option.of(ServiceFileId.valueOf(rawServiceFileId));
            serviceFileInfo = Option.empty();
        }

        return uploadRegistry.saveRecord(MpfsRequestRecordUtils.consF(
                new MpfsRequest.ConvertToMsOoxmlFormat(
                        ApiArgs.getApiVersionAtLeast(reqX, ApiVersion.V_0_2),
                        service,
                        serviceFileId,
                        serviceFileInfo,
                        StringUtils.notEmptyO(ApiArgs.getContentType(reqX)),
                        StringUtils.notEmptyO(ApiArgs.getArchivePath(reqX)),
                        ApiArgs.getChemodanFile(reqX),
                        ApiArgs.getCallbackUri(reqX),
                        ApiArgs.getMaxFileSizeO(reqX),
                        ApiArgs.getYandexCloudRequestId(reqX)),
                RequestRevision.initial(HostInstant.hereAndNow())));
    }
}
