package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecordUtils;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.commune.uploader.registry.RequestRecord;
import ru.yandex.commune.uploader.registry.RequestRevision;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.util.HostInstant;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpRequestUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class ExportPhotosServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ExportPhotosServlet.class);

    @Autowired
    private ControlResponseXmlizer controlResponseXmlizer;
    @Autowired
    private UploadRegistry<MpfsRequestRecord> uploadRegistry;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.info(HttpRequestUtils.describeRemoveSensitive(req));

        HttpServletRequestX reqX = HttpServletRequestX.wrap(req);
        // Upyachka, I use DISK service for back capablitiy,
        // since "mpfs disk 1.23" this parameter would be required
        ChemodanService targetService = ChemodanService.R.valueOf(
                reqX.getParameterO(ApiArgs.PROVIDER).getOrElse(ChemodanService.DISK.name()));
        RequestRecord record = uploadRegistry.saveRecord(MpfsRequestRecordUtils.consF(
                new MpfsRequest.ExportPhotos(
                        ApiArgs.getApiVersion(req),
                        parsePreviewStids(reqX.getParameterO(ApiArgs.PREVIEW_STIDS).getOrElse("")),
                        reqX.getParameterO(ApiArgs.PROFILE_ID).get(),
                        reqX.getParameterO(ApiArgs.ALBUM_ID).get(),
                        targetService,
                        ApiArgs.getCallbackUri(req),
                        ApiArgs.getYandexCloudRequestId(reqX)),
                RequestRevision.initial(HostInstant.hereAndNow())));

        resp.setContentType("application/xml");

        controlResponseXmlizer.write(resp.getOutputStream(), "export-photos", record);
    }

    static ListF<MulcaId> parsePreviewStids(String previevStids) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        List<String> previews = mapper.readValue(previevStids, new TypeReference<List<String>>() {});
        return Cf.list(previews).map(MulcaId.fromSerializedStringF());
    }

}
