package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.chemodan.uploader.web.control.sync.AbstractSyncRequestServlet;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpServletRequestX;
import ru.yandex.misc.xml.stream.JavolutionXmlWriter;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author Lev Tolmachev
 */
@SuppressWarnings("serial")
public class ExtractRotationServlet extends AbstractSyncRequestServlet {
    private static final Logger logger = LoggerFactory.getLogger(ExtractRotationServlet.class);

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        doGet(req, resp);
    }

    @Override
    protected void handleRequest(HttpServletRequestX reqX, HttpServletResponse resp) throws
            IOException
    {
        final MulcaId mulcaId = ApiArgs.getMulcaId(reqX);

        int rotateAngle = processor.extractRotation(mulcaId);

        logger.info("Extracted rotate angle for {}: {}", mulcaId, rotateAngle);
        writeResponse(resp, rotateAngle);
    }

    private void writeResponse(HttpServletResponse resp, int rotateAngle) throws IOException {
        XmlWriter xw = new JavolutionXmlWriter(resp.getOutputStream(), false, "\t");
        resp.setContentType("application/xml");

        xw.startElement("exif");

        xw.textElement("rotation", rotateAngle);

        xw.endElement();
        xw.flush();
        xw.close();
    }
}
